import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllLanguageDatasSvc,
} from './languageData.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {languageDataRes} from './languageData.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const languageDatas = await getAllLanguageDatasSvc();
    return responseJSON(req, res, {data: languageDatas.map((languageData) => languageDataRes(languageData))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
