import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllLoginHistoriesSvc,
} from './loginHistory.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {loginHistoryRes} from './loginHistory.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const loginHistories = await getAllLoginHistoriesSvc();
    return responseJSON(req, res, {data: loginHistories.map((loginHistory) => loginHistoryRes(loginHistory))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
