import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllMasterIndividualBucketsSvc,
} from './masterIndividualBucket.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {masterIndividualBucketRes} from './masterIndividualBucket.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const masterIndividualBuckets = await getAllMasterIndividualBucketsSvc();
    return responseJSON(req, res, {data: masterIndividualBuckets.map((masterIndividualBucket) => masterIndividualBucketRes(masterIndividualBucket))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};

