import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllMasterMembersSvc,
} from './masterMember.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {masterMemberRes} from './masterMember.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const masterMembers = await getAllMasterMembersSvc();
    return responseJSON(req, res, {data: masterMembers.map((masterMember) => masterMemberRes(masterMember))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
