import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllMasterTransactionTestsSvc,
} from './masterTransactionTest.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {masterTransactionTestRes} from './masterTransactionTest.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const masterTransactionTests = await getAllMasterTransactionTestsSvc();
    return responseJSON(req, res, {data: masterTransactionTests.map((masterTransactionTest) => masterTransactionTestRes(masterTransactionTest))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
