import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllMasterWalletTransactionsSvc,
} from './masterWalletTransaction.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {masterWalletRes} from './masterWalletTransaction.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const masterWallets = await getAllMasterWalletTransactionsSvc();
    return responseJSON(req, res, {data: masterWallets.map((masterWallet) => masterWalletRes(masterWallet))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
