export const formatMenuByRole = (data) => {
    const menuMap = {};
    const result = [];
  
    data.forEach((item) => {
      const menu = item.menu;
      if (!menu) return;
  
      const formatted = {
        id: menu.id,
        title: menu.title,
        icon: menu.icon,
        pageName: menu.page_name,
        is_active: menu.is_active,
      };
  
      if (menu.parent_id) {
        // Sub menu
        if (!menuMap[menu.parent_id]) {
          menuMap[menu.parent_id] = { subMenu: [] };
        }
        menuMap[menu.parent_id].subMenu = menuMap[menu.parent_id].subMenu || [];
        menuMap[menu.parent_id].subMenu.push(formatted);
      } else {
        // Top level menu
        menuMap[menu.id] = formatted;
        result.push(formatted);
      }
    });
  
    return result;
  };
  