import { Router } from 'express';
import {
  destroy,
  index,
  show,
  store,
  update,
  tree,
  getMenuByRoleIdController,
  getMenuByAuth,
  updateMenuRoles
} from './menuPanel.controller';
import { authenticateToken } from '../../middleware/jwt';

const menuPanelRouter = Router();

menuPanelRouter.post('/get', index); // Paginated list
menuPanelRouter.get('/tree', tree); // Full tree (nested parent-child)
menuPanelRouter.post('/create', store); // Create new menu
menuPanelRouter.get('/show/:id', show); // Get single menu by ID
menuPanelRouter.post('/update/:id', update); // Update menu by ID
menuPanelRouter.delete('/delete/:id', destroy); // Delete menu by ID
menuPanelRouter.get('/get-menu-role/:id', getMenuByRoleIdController)
menuPanelRouter.get('/get-menu-role-by-auth', authenticateToken, getMenuByAuth)
menuPanelRouter.post('/update-menu-role', authenticateToken, updateMenuRoles)

export default menuPanelRouter;
