import { MenuPanelAttributes } from '../../db/models/MenuPanel';
import {
  createMenuRepository,
  destroyMenuByIdRepository,
  getAllMenuRepository,
  getMenuByIdRepository,
  updateMenuByIdRepository,
  getAllMenusWithSubmenus,
  getMenuByRoleIdRepository,
  updateMenusRoleRelationship,
} from './menuPanel.repository';

export const getAllMenuService = async (
  page: number,
  limit: number,
  pagination: boolean,
) => {
  try {
    console.log('pagination', pagination);
    console.log('page', page);
    console.log('limit', limit);
    return await getAllMenuRepository(page, limit, pagination);
  } catch (error) {
    throw error;
  }
};

export const getMenuByRoleIdService = async (roleId: number) => {
    try{
        return await getMenuByRoleIdRepository(roleId);
    }
    catch (error){
        throw error;
    }
}
export const createMenuService = async (menu: Partial<MenuPanelAttributes>) => {
  try {
    return await createMenuRepository(menu);
  } catch (error) {
    throw error;
  }
};

export const getMenuByIdService = async (id: number) => {
  try {
    return await getMenuByIdRepository(id);
  } catch (error) {
    throw error;
  }
};

export const updateMenuByIdService = async (
  id: number,
  updateData: Partial<MenuPanelAttributes>,
) => {
  try {
    return await updateMenuByIdRepository(id, updateData);
  } catch (error) {
    throw error;
  }
};

export const destroyMenuService = async (id: number) => {
  try {
    return await destroyMenuByIdRepository(id);
  } catch (error) {
    throw error;
  }
};

export const getMenusWithSubmenusService = async () => {
  try {
    return await getAllMenusWithSubmenus();
  } catch (error) {
    throw error;
  }
};

export const updateMenuRolesService = async (roleId: number, menuIds: number[]) => {
  try {
    return await updateMenusRoleRelationship(roleId, menuIds);
  } catch (error) {
    throw error;
  }
};
