import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllPartnerMastersSvc,
} from './partnerMaster.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {partnerMasterRes} from './partnerMaster.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const partnerMasters = await getAllPartnerMastersSvc();
    return responseJSON(req, res, {data: partnerMasters.map((partnerMasters) => partnerMasterRes(partnerMasters))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
