import {Router} from 'express';
import { getPlayerReport} from './playerReport.controller';
import { validatePositiveInts } from '../../middleware/validatePositiveId';
import { authenticateToken } from '../../middleware/jwt';

const reportRouter = Router();

reportRouter.get('/get', authenticateToken, validatePositiveInts(['page', 'limit']), getPlayerReport);

export default reportRouter;
