import {getPlayerGameReportsRpo} from './playerReport.repository';
import {getRoleAppsRpo} from '../role-app-panel/roleAppPanel.repository';

export const getPlayerGameReportsSvc = async (filters: {
  id?: string;
  nickname?: string;
  roleId: number;
  page: number;
  limit: number;
}) => {
  try {

    const [firstApp] = await getRoleAppsRpo(filters.roleId);
    const appId = firstApp?.app_id;

    if (!appId) {
      throw new Error('App ID not found for the given role.');
    }

    console.log('dataByRole', appId);
    const {results, total} = await getPlayerGameReportsRpo({appId,filters});

    const mappedResults = results.map((result: any) => ({
      platform_id: result.platform_id,
      id: result.member_id,
      player_id: result.client_player_id,
      nick: result.nickname,
      platform: result.platform_name,
      currency: result.currency,
      coin: parseFloat(result.coin) === 0 ? 0 : parseFloat(result.coin),
      total_depo: parseFloat(result.totaldepo) === 0 ? 0 : parseFloat(result.totaldepo),
      total_wd: parseFloat(result.totalwd) === 0 ? 0 : parseFloat(result.totalwd),
      player_profit: parseFloat(result.player_profit) === 0 ? 0 : parseFloat(result.player_profit),
      created_date: result.create_date,
      updated_date: result.update_date,
    }));

    return {results: mappedResults, total};
  } catch (error) {
    console.error('getPlayerReportsSvc error:', error);
    throw new Error('Failed to process player report data.');
  }
};
