import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllPopularGamesSvc,
} from './popularGame.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {popularGameRes} from './popularGame.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const popularGames = await getAllPopularGamesSvc();
    return responseJSON(req, res, {data: popularGames.map((popularGame) => popularGameRes(popularGame))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
