import { getReplayGamesRpo } from './replayRecord.repository';
const crypto = require('crypto');

export function encrypt(data: any) {
  const iv = crypto.randomBytes(Number(process.env.IVLENGTH));
  const key = Buffer.from(process.env.HASH_SECRET, 'hex');
  const cipher = crypto.createCipheriv(process.env.ALGORYTHM, key, iv);

  const jsonString = typeof data === 'string' ? data : JSON.stringify(data);
  let encrypted = cipher.update(jsonString, 'utf8', 'hex');
  encrypted += cipher.final('hex');

  return {
    iv: iv.toString('hex'),
    encryptedData: encrypted
  };
}

export const generateEncryptedReplayUrls = (rows: any[]) => {
  const PREFIX_URL = process.env.PREFIX_URL || '';

  return rows.map((row: any) => {
    const encryptData = {
      transaction_id: row.agt_id,
      game_id: row.gl_id,
      app_id: row.mm_client_id,
      currency: row.mib_currency,
      language: row.mm_language,
    };

    const { encryptedData, iv } = encrypt(encryptData);
    const token = `${iv}:${encryptedData}`;
    const safeToken = encodeURIComponent(token);
    const encryptedUrl =  row.replay_url ? `${PREFIX_URL}${row.replay_url}?round_id=${safeToken}` : null;

    return {
      ...row,
      replay_url: encryptedUrl,
    };
  });
};

export const getReplayGamesSvc = async (filters: {
  roundId?: string;
  gameId?: number;
  page: number;
  limit: number;
}) => {
  try {
    let queryFilters: any = {
      gameId: filters.gameId,
      page: filters.page,
      limit: filters.limit,
    };

    if (filters.roundId === '' && filters.gameId == null) {
      return { results: [], total: 0 };
    }

    if (filters.roundId && filters.roundId.includes('_')) {
      const roundIdParts = filters.roundId.split('_');
      if (roundIdParts.length === 2 && roundIdParts[0].trim() && roundIdParts[1].trim()) {
        const gameInfo = roundIdParts[0];
        const transactionId = roundIdParts[1];
        const match = gameInfo.match(/^([a-zA-Z\d]+?)(\d+)$/);

        if (match && match.length === 3) {
          const gameCode = match[1];
          const gameNumber = match[2];
          queryFilters = {
            ...queryFilters,
            gameCode,
            gameNumber,
            transactionId,
          };
        } else {
          return { results: [], total: 0 };
        }
      } else {
        return { results: [], total: 0 };
      }
    } else if (filters.roundId) {
      return { results: [], total: 0 };
    }

    // Ambil data dari repository
    const { results, total } = await getReplayGamesRpo(queryFilters);
    // Tambahkan encrypted replay_url
    const resultsWithEncryptedUrls = generateEncryptedReplayUrls(results);

    // Format hasil untuk client
    const formatted = resultsWithEncryptedUrls.map((row: any) => ({
      roundId: `${row.game_type_id}${row.gl_id}_${row.agt_id}`,
      userId: row.member_id,
      userName: row.userName,
      coinBet: row.coin_bet,
      multiplier: row.multiplier,
      total: row.coin_bet + row.coin_result,
      transactionDate: row.transaction_date,
      replayUrl: row.replay_url,
      gameName: row.game_name,
    }));

    return { results: formatted, total };
  } catch (error) {
    console.error('getReplayGamesSvc error:', error);
    throw new Error('Failed to process replay games data.');
  }
};
