import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getDailyReportsSvc,
  getMonthlyReportsSvc,
  getYearlyReportsSvc,
  getPlayerGameReportsSvc
} from './report.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {reportRes} from './report.dto';

import ExcelJS from 'exceljs';


export const dailyReport = async (req: Request, res: Response) => {
  try {
    const { start_time, end_time, name, currency, is_export } = req.body;

    // Parsing date supaya sesuai tipe Date
    const filters = {
      name,
      currency,
      start_time: start_time ? new Date(start_time) : undefined,
      end_time: end_time ? new Date(end_time) : undefined,
    };

    const results = await getDailyReportsSvc(filters);

    if (is_export === true) {
      const workbook = new ExcelJS.Workbook();
      const worksheet = workbook.addWorksheet('Report');

      if (results.length > 0) {
        worksheet.addRow(Object.keys(results[0]));
        results.forEach((result) => {
          worksheet.addRow(Object.values(result));
        });
      }

      res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      res.setHeader('Content-Disposition', 'attachment; filename=report.xlsx');

      await workbook.xlsx.write(res);
      res.end();
      return;
    }

    return res.status(200).json({
      code: "1",
      msg: "success",
      data_count: results.length,
      dayReport: results,
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({ status: 0, error: "Internal server error" });
  }
};


export const monthlyReport = async (req: Request, res: Response) => {
  try {
    const { start_time, end_time, name, currency, is_export } = req.body;

    const filters = {
      name,
      currency,
      start_time: start_time ? new Date(start_time) : undefined,
      end_time: end_time ? new Date(end_time) : undefined,
    };

    const results = await getMonthlyReportsSvc(filters);

    if (is_export === true) {
      const workbook = new ExcelJS.Workbook();
      const worksheet = workbook.addWorksheet('Monthly Report');

      if (results.length > 0) {
        worksheet.addRow(Object.keys(results[0]));
        results.forEach((result) => {
          worksheet.addRow(Object.values(result));
        });
      }

      res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      res.setHeader('Content-Disposition', 'attachment; filename=monthly_report.xlsx');

      await workbook.xlsx.write(res);
      res.end();
      return;
    }

    return res.status(200).json({
      code: "1",
      msg: "success",
      data_count: results.length,
      monthReport: results,
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({ status: 0, error: "Internal server error" });
  }
};


export const yearlyReport = async (req: Request, res: Response) => {
  try {
    const { start_time, end_time, name, currency, is_export } = req.body;

    const filters = {
      name,
      currency,
      start_time: start_time ? new Date(start_time) : undefined,
      end_time: end_time ? new Date(end_time) : undefined,
    };

    const results = await getYearlyReportsSvc(filters);

    if (is_export === true) {
      const workbook = new ExcelJS.Workbook();
      const worksheet = workbook.addWorksheet('Report');

      if (results.length > 0) {
        worksheet.addRow(Object.keys(results[0]));
        results.forEach((result) => {
          worksheet.addRow(Object.values(result));
        });
      }

      res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      res.setHeader('Content-Disposition', 'attachment; filename=report.xlsx');

      await workbook.xlsx.write(res);
      res.end();
      return;
    }

    return res.status(200).json({
      code: "1",
      msg: "success",
      data_count: results.length,
      dayReport: results,
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({ status: 0, error: "Internal server error" });
  }
};


export const playerGameReport = async (req: Request, res: Response) => {
  try {
    const { member_id, is_export } = req.body;

    const filters = {
      member_id,
    };

    const results = await getPlayerGameReportsSvc(filters);

    if (is_export === true) {
      const workbook = new ExcelJS.Workbook();
      const worksheet = workbook.addWorksheet('Report');

      if (results.length > 0) {
        worksheet.addRow(Object.keys(results[0]));
        results.forEach((result) => {
          worksheet.addRow(Object.values(result));
        });
      }

      res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      res.setHeader('Content-Disposition', 'attachment; filename=report.xlsx');

      await workbook.xlsx.write(res);
      res.end();
      return;
    }

    return res.status(200).json({
      code: "1",
      msg: "success",
      data_count: results.length,
      dayReport: results,
    });
  } catch (error) {
    console.error("Error executing query:", error);
    return res.status(500).json({ status: 0, error: "Internal server error" });
  }
};