import seq from '../../db/config';

import sequelize from '../../db/config'; // pastikan ini adalah instance Sequelize yang sudah kamu buat dan konek ke DB
import { QueryTypes } from 'sequelize';

export const geReportsRpo = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  let query = `SELECT * FROM "pik_master"."report_platformSummaryDay"`;
  let replacements: any = {};
  let queryAddon = "";

  if (filters.name !== undefined) {
    queryAddon += ' WHERE name = :name';
    replacements.name = filters.name;
  }

  if (filters.currency !== undefined) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'currency = :currency';
    replacements.currency = filters.currency;
  }

  if (filters.start_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'trandate >= :start_time';
    replacements.start_time = filters.start_time;
  }

  if (filters.end_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'trandate <= :end_time';
    replacements.end_time = filters.end_time;
  }

  queryAddon += ' ORDER BY trandate DESC';
  const finalQuery = query + queryAddon;

  const results = await sequelize.query(finalQuery, {
    replacements,
      type: QueryTypes.SELECT, // pakai QueryTypes yang diimport langsung
  });

  return results;
};


export const geMonthlyReportsRpo = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  let query = `SELECT * FROM "pik_master"."report_platformSummaryMonth"`;
  let replacements: any = {};
  let queryAddon = "";

  if (filters.name !== undefined) {
    queryAddon += ' WHERE name = :name';
    replacements.name = filters.name;
  }

  if (filters.currency !== undefined) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'currency = :currency';
    replacements.currency = filters.currency;
  }

  if (filters.start_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'trandate >= :start_time';
    replacements.start_time = filters.start_time;
  }

  if (filters.end_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'trandate <= :end_time';
    replacements.end_time = filters.end_time;
  }

  queryAddon += ' ORDER BY trandate DESC';
  const finalQuery = query + queryAddon;

  const results = await sequelize.query(finalQuery, {
    replacements,
    type: QueryTypes.SELECT,
  });

  return results;
};


// src/features/report/report.repository.ts
export const getYearlyReportsRpo = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  let query = `SELECT * FROM "pik_master"."report_platformSummaryYear"`;
  let replacements: any = {};
  let queryAddon = "";

  if (filters.name !== undefined) {
    queryAddon += ' WHERE name = :name';
    replacements.name = filters.name;
  }

  if (filters.currency !== undefined) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + 'currency = :currency';
    replacements.currency = filters.currency;
  }

  if (filters.start_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + `trandate >= :start_time`;
    replacements.start_time = filters.start_time;
  }

  if (filters.end_time) {
    queryAddon += (queryAddon ? ' AND ' : ' WHERE ') + `trandate <= :end_time`;
    replacements.end_time = filters.end_time;
  }

  queryAddon += ' ORDER BY trandate DESC';
  const finalQuery = query + queryAddon;

  const results = await sequelize.query(finalQuery, {
    replacements,
    type: QueryTypes.SELECT,
  });

  return results;
};

export const getPlayerGameReportsRpo = async (filters: { member_id?: string }) => {
  let query = `SELECT * FROM "pik_master"."report_playerPerGame"`;
  let replacements: any = {};
  let queryAddon = "";

  if (filters.member_id !== undefined) {
    queryAddon += ' WHERE member_id = :member_id';
    replacements.member_id = filters.member_id;
  }

  const finalQuery = query + queryAddon;

  const results = await sequelize.query(finalQuery, {
    replacements,
    type: QueryTypes.SELECT,
  });

  return results;
};

