import {
  geReportsRpo,
  geMonthlyReportsRpo,
  getYearlyReportsRpo,
  getPlayerGameReportsRpo
} from './report.repository';

export const getDailyReportsSvc = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  const reports = await geReportsRpo(filters);
  return reports;
};

export const getMonthlyReportsSvc = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  const reports = await geMonthlyReportsRpo(filters);
  return reports;
};

// src/features/report/report.service.ts
export const getYearlyReportsSvc = async (filters: {
  name?: string;
  currency?: string;
  start_time?: Date;
  end_time?: Date;
}) => {
  const reports = await getYearlyReportsRpo(filters);
  return reports;
};

export const getPlayerGameReportsSvc = async (filters: { member_id?: string }) => {
  const reports = await getPlayerGameReportsRpo(filters);
  return reports;
};


