import sequelize from '../../db/config';
import {QueryTypes} from 'sequelize';
import RoleAppPanel from '../../db/models/RoleAppPanel';

export const getRoleAppsRpo = async (roleId: number) => {
  try {
    console.log('masuk role id', roleId);

    const data = await RoleAppPanel.findAll({
      attributes: ['id', 'app_id'],
      where: {
        role_id: roleId,
      },
    });

    return data;
  } catch (error) {
    console.error('getRoleAppsRpo error:', error);
    throw new Error('Failed to get role apps.');
  }
};