import { Router } from 'express';
import {
  getRolePanelController,
  createRolePanelController,
  updateRolePanelController,
  getRolePanelByIdController,
  deleteRolePanelController,
} from './rolepanel.controller';

const rolePanelRouter = Router();

// Routes
rolePanelRouter.get('/list-role-panel', getRolePanelController);
rolePanelRouter.post('/create-role-panel', createRolePanelController);
rolePanelRouter.put('/update-role-panel/:id', updateRolePanelController);
rolePanelRouter.get('/detail-role-panel/:id', getRolePanelByIdController);
rolePanelRouter.delete('/delete-role-panel/:id', deleteRolePanelController);

export default rolePanelRouter;
