import { RolePanelAttributes } from '../../db/models/RolePanel';
import {
  getRolePanelRepository,
  getRolePanelByIdRepository,
  createRolePanelRepository,
  updateRolePanelRepository,
  deleteRolePanelRepository,
} from './rolepanel.repository';

// Get all roles with pagination and optional search
export const getRolePanelService = async (page: number, pageSize: number, search: string) => {
  return await getRolePanelRepository({}, { page, pageSize, search });
};

// Create a new role
export const createRolePanelService = async (data: RolePanelAttributes) => {
  return await createRolePanelRepository(data);
};

// Update a role by ID
export const updateRolePanelService = async (roleId: string, data: Partial<RolePanelAttributes>) => {
  return await updateRolePanelRepository(roleId, data);
};

// Get role by ID
export const getRolePanelByIdService = async (roleId: string) => {
  return await getRolePanelByIdRepository(roleId);
};

// Delete role by ID
export const deleteRolePanelService = async (roleId: string) => {
  return await deleteRolePanelRepository(roleId);
};
