import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllSeamlessWalletsSvc,
} from './seamlessWallet.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {seamlessWalletRes} from './seamlessWallet.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const seamlessWallets = await getAllSeamlessWalletsSvc();
    return responseJSON(req, res, {data: seamlessWallets.map((seamlessWallet) => seamlessWalletRes(seamlessWallet))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
