import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllServiceResponsesSvc,
} from './serviceResponse.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {serviceResponseRes} from './serviceResponse.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const ServiceResponses = await getAllServiceResponsesSvc();
    return responseJSON(req, res, {data: ServiceResponses.map((ServiceResponse) => serviceResponseRes(ServiceResponse))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
