import {Request, Response} from 'express';
import * as Joi from 'joi';
import {getAllWalletTransactionsService} from './walletTransactionReport.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {isValidPositiveInt} from '../../utils/validators';
import {walletTransactionRes} from './walletTransactionReport.dto';

export interface AuthenticatedRequest extends Request {
  user?: any;
  id?: string;
  roleId?: number;
}
export const index = async (req: AuthenticatedRequest, res: Response) => {
  try {
    const roleId = req.roleId; // Ambil dari middleware jwt
    console.log('roleId', roleId);

    const {
      page = '1',
      limit: limitQuery,
      size,
      pg,
      start_time,
      end_time,
      player_id,
      player_action,
      trx_id,
      player_name,
    } = req.query;

    const currentPage = parseInt(page as string, 10) || 1;
    const limit = parseInt((limitQuery || size || '10') as string, 10);
    const usePagination = pg === 'true' || pg === '1';

    const filters = {
      playerName: player_name?.toString(),
      startTime: start_time ? new Date(start_time.toString()) : undefined,
      endTime: end_time ? new Date(end_time.toString()) : undefined,
      playerId: player_id?.toString(),
      playerAction: player_action?.toString().toUpperCase(),
      txId: trx_id?.toString(),
    };

    console.log('Filters:', filters);

    const result = await getAllWalletTransactionsService(
      currentPage,
      limit,
      usePagination,
      roleId,
      filters,
    );

    const transformedData = result.data.map(walletTransactionRes);

    let paginationInfo;
    if (usePagination && result.pagination) {
      const { totalRecords, totalPages, currentPage } = result.pagination;
      paginationInfo = {
        page: currentPage,
        limit,
        total: totalRecords,
        totalPages,
        prevPage: currentPage > 1 ? currentPage - 1 : null,
        nextPage: currentPage < totalPages ? currentPage + 1 : null,
      };
    }

    return responseJSON(req, res, {
      data: transformedData,
      ...(paginationInfo && { pagination: paginationInfo }),
    });
  } catch (error: any) {
    return responseJSON(req, res, { message: error.message }, true);
  }
};


// export const index = async (req: AuthenticatedRequest, res: Response) => {
//   try {
//     const roleId = req.roleId; // Ambil dari middleware jwt
//     console.log('roleId', roleId)
//     const page = parseInt(req.query.page as string, 10) || 1;
//     const limit = parseInt(req.query.size as string, 10) || 10;
//     const pagination = req.query.pg === 'true' || req.query.pg === '1';

//     const startTime = req.query.start_time
//       ? new Date(String(req.query.start_time))
//       : undefined;
//     const endTime = req.query.end_time
//       ? new Date(String(req.query.end_time))
//       : undefined;

//     const playerId = req.query.player_id
//       ? String(req.query.player_id)
//       : undefined;
//     const playerAction = req.query.player_action
//       ? String(req.query.player_action).toUpperCase()
//       : undefined;
//     const txId = req.query.trx_id ? String(req.query.trx_id) : undefined;
//     const playerName = req.query.player_name
//       ? String(req.query.player_name)
//       : undefined;

//     // const clientPlayerId = req.query.client_player_id ? String(req.query.client_player_id) : undefined;
//     console.log('playerAction', playerAction);
//     console.log('playerName', playerName);
//     console.log('txId', txId);
//     console.log('playerId', playerId);
//     const result = await getAllWalletTransactionsService(
//       page,
//       limit,
//       pagination,
//       roleId,
//       {playerName, startTime, endTime, playerId, playerAction, txId},
//     );

//     const transformedData = result.data.map(walletTransactionRes);

//     return responseJSON(req, res, {
//       data: transformedData,
//       ...(result.pagination && {pagination: result.pagination}),
//     });
//   } catch (error: any) {
//     return responseJSON(req, res, {message: error.message}, true);
//   }
// };
