import {Op} from 'sequelize';
import ReportTransferDetail from '../../db/models/ReporTransferDetail';

export const getWalletTransactionReportsRpo = async (
  appId: string,
  page: number,
  limit: number,
  pagination: boolean,
  filters?: {
    playerName?: string;
    startTime?: Date;
    endTime?: Date;
    playerId?: string;
    clientPlayerId?: string;
    playerAction?: string;
    txId?: string;
  },
) => {
  try {
    const whereClause: any = {};

    // Search by player name
    if (filters?.playerName) {
      whereClause[Op.or] = [{name: {[Op.like]: `%${filters?.playerName}%`}}];
    }

    // Filter by date range
    if (filters?.startTime && filters?.endTime) {
      whereClause.trandate = {
        [Op.between]: [filters.startTime, filters.endTime],
      };
    } else if (filters?.startTime) {
      whereClause.trandate = {
        [Op.gte]: filters.startTime,
      };
    } else if (filters?.endTime) {
      whereClause.trandate = {
        [Op.lte]: filters.endTime,
      };
    }

    // Filter by app_id
    if (filters?.playerId) {
      whereClause.client_player_id = filters.playerId;
    }

    // Filter by player_action
    if (filters?.playerAction && filters.playerAction !== 'ALL') {
      whereClause.player_action = filters.playerAction;
    }


    if (appId) {
      whereClause.app_id = appId;
    }


    // Filter by tx_id
    if (filters?.txId) {
      whereClause.tx_id = filters.txId;
    }

    if (pagination) {
      const offset = (page - 1) * limit;
      const {count, rows} = await ReportTransferDetail.findAndCountAll({
        where: whereClause,
        offset,
        limit,
        subQuery: false,
        order: [['trandate', 'DESC']],
      });

      const totalPages = Math.ceil(count / limit);

      return {
        data: rows.map((row) => row.toJSON()),
        pagination: {
          totalRecords: count,
          totalPages,
          currentPage: page,
        },
      };
    } else {
      const rows = await ReportTransferDetail.findAll({
        where: whereClause,
        order: [['trandate', 'DESC']],
      });

      return {
        data: rows.map((row) => row.toJSON()),
        totalRecords: rows.length,
      };
    }
  } catch (error) {
    throw error;
  }
};
