import {getWalletTransactionReportsRpo} from './walletTransactionReport.repository';
import {getRoleAppsRpo} from '../role-app-panel/roleAppPanel.repository';
// import {
//   getAllGameTransactionsRepository,
//   getGameTransactionByIdRepository,
// } from './allGameTransaction.repository';

/**
 * Get all game transactions with optional pagination and search
 */
export const getAllWalletTransactionsService = async (
  page: number = 1,
  limit: number = 10,
  pagination: boolean = true,
  roleId: number,
  filters?: {
    playerName?: string;
    startTime?: Date;
    endTime?: Date;
    playerId?: string;
    playerAction?: string;
    txId?: string;
  },
) => {
  try {
    const [firstApp] = await getRoleAppsRpo(roleId);
    const appId = firstApp?.app_id;
    console.log('dataByRole', appId);

    if (!appId) {
      throw new Error('App ID not found for the given role.');
    }

    const data = await getWalletTransactionReportsRpo(
      appId,
      page,
      limit,
      pagination,
      filters,
    );
    return data;
  } catch (error) {
    throw error;
  }
};
