import { Request, Response, NextFunction } from 'express';
import { isValidPositiveInt } from '../utils/validators';

export function validatePositiveInts(fields: string[]) {
  return (req: Request, res: Response, next: NextFunction) => {
    const errors: Record<string, string> = {};

    fields.forEach((field) => {
      const value = req.query[field];
        console.log('field', field)
        console.log('value', value)
      if (value !== undefined && !isValidPositiveInt(value)) {
        errors[field] = `${field} must be a positive number`;
      }
    });

    if (Object.keys(errors).length > 0) {
      return res.status(400).json({
        status: 'error',
        message: 'Validation failed',
        errors,
        code: 400,
      });
    }

    next();
  };
}
