import {Router} from 'express';
import partnerRouter from '../features/partner/partner.router';
import userRouter from '../features/users/user.router';
import {serviceMiddleware} from '../middleware/middleware';
import {authenticateToken} from '../middleware/jwt';
import authRouter from '../features/auth/auth.router';
import clientRouter from '../features/client/client.router';
import currencyRouter from '../features/currency/currency.router';
import domainListRouter from '../features/domain-list/domainList.router';
import gameListRouter from '../features/game-list/gameList.router';
import masterIndividualBucketRouter from '../features/master-individual-bucket/masterIndividualBucket.router';
import masterMemberRouter from '../features/master-member/masterMember.router';
import masterTransactionTestRouter from '../features/master-transaction-test/masterTransactionTest.router';
import masterWalletTransactionRouter from '../features/master-wallet-transaction/masterWalletTransaction.router';
import languageDataRouter from '../features/language-data/languageData.router';
import loginHistoryRouter from '../features/loginHistory/loginHistory.router';
import popularGameRouter from '../features/popular-game/popularGame.router'
import seamlessWalletRouter from '../features/seamless-wallet/seamlessWallet.router'
import serviceResponseRouter from '../features/service-response/serviceResponse.router'
import partnerMasterRouter from '../features/partner-master/partnerMaster.router'
import reportRouter from '../features/report/report.router'

const router = Router();

router.use('/access-token', partnerRouter);
router.use('/users', authenticateToken, userRouter);
router.use('/client', clientRouter);
router.use('/currency', currencyRouter);
router.use('/domain-list', domainListRouter);
router.use('/game-list', gameListRouter);
router.use('/master-individual-bucket', masterIndividualBucketRouter);
router.use('/master-member', masterMemberRouter);
router.use('/master-transaction-test', masterTransactionTestRouter);
router.use('/master-wallet-transaction', masterWalletTransactionRouter);
router.use('/language-data', languageDataRouter);
router.use('/login-history', loginHistoryRouter);
router.use('/popular-game', popularGameRouter);
router.use('/seamless-wallet', seamlessWalletRouter);
router.use('/service-response', serviceResponseRouter);
router.use('/partner-master', partnerMasterRouter);
router.use('/report', reportRouter);
router.use('/auth', authRouter);

export default router;
