import {Router} from 'express';
import replayRecordRouter from '../features/replay-record/replayRecord.router';
import gameListRouter from '../features/game-list/gameList.router';
import authRouter from '../features/auth/authV2.router';
import homeRouter from '../features/home/home.router';
import rolePanelRouter from '../features/role-panel/rolepanel.router';
import authPanelRouter from '../features/auth-panel/authPanel.router';
import menuPanelRouter from '../features/menu-panel/menuPanel.router';
import playerReportRouter from '../features/player-report/playerReport.router';
import walletTransactionReportRouter from '../features/wallet-transaction-report/walletTransactionReport.router';
import allGameTransactionRouter from '../features/all-game-transaction/allGameTransaction.router';

const routerV2 = Router();

routerV2.use('/replay', replayRecordRouter);
routerV2.use('/home', homeRouter);
routerV2.use('/game-list', gameListRouter);
routerV2.use('/admin', authRouter);
routerV2.use('/role-panel', rolePanelRouter);
routerV2.use('/auth', authRouter);
routerV2.use('/auth', authPanelRouter);
routerV2.use('/menu', menuPanelRouter);
routerV2.use('/player-report', playerReportRouter);
routerV2.use('/wallet-transaction-report', walletTransactionReportRouter);
routerV2.use('/game-transaction', allGameTransactionRouter);

export default routerV2;
